//texture tex0 < string ResourceName = "C:\\diplomacy\\Executable\\gfx\\map\\default\\water.tga"; >;
//texture tex1 < string ResourceName = "C:\\diplomacy\\Executable\\gfx\\map\\default\\water_normal.tga"; >;
//string XFile = "C:\\diplomacy\\Executable\\gfx\\map\\default\\water.x";   // Model to load

// Here is a vector parameter representing the direction
// vector from a light source.  The UIDirectional annotation
// tells EffectEdit to create a user interface element that can
// be used to interactively change the light direction.
float4 LightDirection = {1.0, 1.0, 1.0, 1.0};
float4 lightDir2 = {1.0, 1.0, 1.0, 1.0};

float4x4 WorldViewProjectionMatrix;

sampler BaseTexture  =
sampler_state
{
##	Texture = <tex0>;
	MinFilter = Linear; //Point;
	MagFilter = Linear;
	WrapS = Repeat;
	WrapT = Repeat;
};

sampler NormalMap  =
sampler_state
{
##	Texture = <tex1>;
	MinFilter = Linear; //Point;
	MagFilter = Linear;
	WrapS = Repeat;
	WrapT = Repeat;
};

struct VS_INPUT
{
    float3 vPosition  : POSITION;
    float3 vNormal	  : NORMAL;
    float2 vTexCoord  : TEXCOORD0;
};

struct VS_OUTPUT
{
    float4  vPosition : POSITION;
    float2  vTexCoord : TEXCOORD0;
};

VS_OUTPUT VertexShaderWater( const VS_INPUT v )
{
	VS_OUTPUT Out = (VS_OUTPUT)0;
    Out.vPosition  = mul(float4(v.vPosition.xyz , 1.0), WorldViewProjectionMatrix);
    Out.vTexCoord  = v.vTexCoord;
    return Out;
}

float4 PixelShaderWater( VS_OUTPUT v ) : COLOR
{
	float4 baseTexture = tex2D(BaseTexture,v.vTexCoord.xy);
	float3 normalTexture = tex2D(NormalMap,v.vTexCoord.xy);
	normalTexture = normalTexture * 2 +(-1);
	float3 lightReflection = (float3)reflect(LightDirection.xyz, (float3)normalTexture );
	lightReflection = normalize( lightReflection );
	float diff = dot( normalTexture.xyz, -lightReflection.xyz );
	float4 color = float4( 0.2, 0.2, 0.2, 1 ) * diff * 1.05f;
	color.a = 0.4f;
	return color;
}

technique tec0
{
    pass p0
    {
		BlendEnable = true;

		VertexProgram = compile arbvp1 VertexShaderWater();
		FragmentProgram = compile arbfp1 PixelShaderWater();
    }
}
